/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;

public class Mensaje {
    private static Mensaje INSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createInstance() {
        if (INSTANCE != null) return;
        Class<Mensaje> clazz = Mensaje.class;
        synchronized (Mensaje.class) {
            if (INSTANCE != null) return;
            INSTANCE = new Mensaje();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Mensaje getInstance() {
        if (INSTANCE == null) {
            Mensaje.createInstance();
        }
        return INSTANCE;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void show(Alert.AlertType tipo, String titulo, String mensaje) {
        Alert alert = new Alert(tipo);
        alert.setTitle(titulo);
        alert.setHeaderText(null);
        alert.setContentText(mensaje);
        alert.show();
    }

    public void showModal(Alert.AlertType tipo, String titulo, Window padre, String mensaje) {
        Alert alert = new Alert(tipo);
        alert.setTitle(titulo);
        alert.setHeaderText(null);
        alert.initOwner(padre);
        alert.setContentText(mensaje);
        alert.showAndWait();
    }

    public Boolean showConfirmation(String titulo, Window padre, String mensaje) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(titulo);
        alert.setHeaderText(null);
        alert.initOwner(padre);
        alert.setContentText(mensaje);
        Optional result = alert.showAndWait();
        return result.get() == ButtonType.OK;
    }

    public Integer showCustomOption(String titulo, Window padre, String mensaje, List<String> opciones) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(titulo);
        alert.setHeaderText(null);
        alert.initOwner(padre);
        alert.setContentText(mensaje);
        ArrayList botones = new ArrayList();
        opciones.stream().map(opcion -> new ButtonType(opcion)).forEach(boton -> botones.add(boton));
        alert.getButtonTypes().clear();
        alert.getButtonTypes().addAll(botones);
        Optional result = alert.showAndWait();
        for (int i = 0; i < botones.size(); ++i) {
            if (botones.get(i) != result.get()) continue;
            return i;
        }
        return null;
    }
}

