/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import electricpos.util.Parametros;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Packager {
    private static final byte[] BUFFER = new byte[0x400000];

    public static List<File> listarArchivos(String extension, List<String> excluir) {
        File[] archivos;
        File raiz = new File(Parametros.rutalog);
        raiz.mkdir();
        ArrayList<File> lista = new ArrayList<File>();
        for (File archivo : archivos = raiz.listFiles((file, name) -> name.matches("([^\\s]+(\\.(?i)(" + extension + "))$)") && !excluir.contains(name) && name.contains(Parametros.sistema))) {
            if (archivo.isDirectory()) continue;
            lista.add(archivo);
        }
        return lista;
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        while ((bytesRead = input.read(BUFFER)) != -1) {
            output.write(BUFFER, 0, bytesRead);
        }
    }

    public static void packZip(String zip, List<File> sources) throws IOException {
        ArrayList<String> archivos = new ArrayList<String>();
        System.out.println("Comprimiendo " + zip);
        boolean append = false;
        File output = new File(Parametros.rutalog + zip);
        append = output.exists();
        if (append) {
            File tmpFile = new File(Parametros.rutalog + zip + ".tmp");
            output.renameTo(tmpFile);
            output = new File(Parametros.rutalog + zip);
        }
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(output));
        zipOut.setLevel(-1);
        for (File source : sources) {
            archivos.add(source.getName());
            if (source.isDirectory()) {
                Packager.zipDir(zipOut, "", source);
                continue;
            }
            Packager.zipFile(zipOut, "", source);
        }
        if (append) {
            ZipFile origen = new ZipFile(Parametros.rutalog + zip + ".tmp");
            Enumeration<? extends ZipEntry> entries = origen.entries();
            while (entries.hasMoreElements()) {
                ZipEntry e = entries.nextElement();
                System.out.println("copia: " + e.getName());
                boolean incluir = true;
                for (String archivo : archivos) {
                    if (!e.getName().matches(archivo)) continue;
                    incluir = false;
                }
                if (!incluir) continue;
                zipOut.putNextEntry(e);
                if (!e.isDirectory()) {
                    Packager.copy(origen.getInputStream(e), zipOut);
                }
                zipOut.closeEntry();
            }
            origen.close();
            new File(Parametros.rutalog + zip + ".tmp").delete();
        }
        zipOut.flush();
        zipOut.close();
        System.out.println("Terminando");
    }

    private static String buildPath(String path, String file) {
        if (path == null || path.isEmpty()) {
            return file;
        }
        return path + Parametros.rutalog + file;
    }

    private static void zipDir(ZipOutputStream zos, String path, File dir) throws IOException {
        if (!dir.canRead()) {
            System.out.println("No se puede leer " + dir.getCanonicalPath() + " (posiblemente sea por permisos)");
            return;
        }
        File[] files = dir.listFiles();
        path = Packager.buildPath(path, dir.getName());
        System.out.println("Agregando directorio " + path);
        for (File source : files) {
            if (source.isDirectory()) {
                Packager.zipDir(zos, path, source);
                continue;
            }
            Packager.zipFile(zos, path, source);
        }
        System.out.println("Abandonando directorio " + path);
    }

    private static void zipFile(ZipOutputStream zos, String path, File file) throws IOException {
        if (!file.canRead()) {
            System.out.println("No se puede leer " + file.getCanonicalPath() + " (posiblemente sea por permisos)");
            return;
        }
        System.out.println("Comprimiendo: " + file.getName());
        zos.putNextEntry(new ZipEntry(Packager.buildPath(path, file.getName())));
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[4092];
        int byteCount = 0;
        while ((byteCount = fis.read(buffer)) != -1) {
            zos.write(buffer, 0, byteCount);
            System.out.print('.');
            System.out.flush();
        }
        System.out.println();
        fis.close();
        zos.closeEntry();
    }
}

