/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Parametros {
    private static Parametros INSTANCE = null;
    private FileInputStream configFile;
    private Properties appProperties;
    public static String rutalog;
    public static String sistema;
    public static String resturl;

    private Parametros() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createInstance() {
        if (INSTANCE != null) return;
        Class<Parametros> clazz = Parametros.class;
        synchronized (Parametros.class) {
            if (INSTANCE != null) return;
            INSTANCE = new Parametros();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Parametros getInstance() {
        if (INSTANCE == null) {
            Parametros.createInstance();
        }
        return INSTANCE;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Boolean cargarParametros() {
        try {
            this.configFile = new FileInputStream("resources/properties.ini");
            this.appProperties = new Properties();
            this.appProperties.load(this.configFile);
            this.configFile.close();
            if (this.appProperties.getProperty("parametros.rutalog") != null) {
                rutalog = this.appProperties.getProperty("parametros.rutalog");
            }
            if (this.appProperties.getProperty("parametros.sistema") != null) {
                sistema = this.appProperties.getProperty("parametros.sistema");
            }
            if (this.appProperties.getProperty("parametros.resturl") != null) {
                resturl = this.appProperties.getProperty("parametros.resturl");
            }
            return true;
        }
        catch (IOException io) {
            System.out.println("Archivo de configuraci\u00f3n no encontrado");
            return false;
        }
    }

    private void actualizarParametros() {
        try {
            this.appProperties.store(new FileOutputStream("resources/properties.ini"), "Par\u00e1metros del sistema.");
        }
        catch (IOException ex) {
            Logger.getLogger(Parametros.class.getName()).log(Level.SEVERE, "Error actualizando los par\u00e1metros del sistema.", ex);
        }
    }

    public String getAppProperty(String nombre) {
        return this.appProperties.getProperty("parametros." + nombre);
    }

    public void setAppProperty(String nombre, String valor) {
        this.appProperties.put("parametros." + nombre, valor);
        this.actualizarParametros();
    }
}

