/*
 * Decompiled with CFR 0.152.
 */
package electricpos.util;

import electricpos.model.TokenDto;
import electricpos.util.AppContext;
import electricpos.util.Parametros;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public final class Request {
    private final Client client = ClientBuilder.newClient();
    private Invocation.Builder builder;
    private WebTarget webTarget;
    private Response response;
    private Future<Response> responseFuture;
    public String urlBase = "http://68.183.129.216:8080/ElectricPosWs/wsPos/";

    public Request() {
    }

    public Request(String target) {
        this.setTarget(target);
    }

    public Request(String target, boolean b) {
        this.webTarget = this.client.target(target);
        this.builder = this.webTarget.request(new String[]{"application/json"});
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Content-Type", (Object)"application/json; charset=UTF-8");
        this.builder.headers((MultivaluedMap)headers);
    }

    public Request(String target, String parametros, Map<String, Object> valores) {
        this.webTarget = this.client.target(this.urlBase + target).path(parametros).resolveTemplates(valores);
        this.builder = this.webTarget.request(new String[]{"application/json"});
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Content-Type", (Object)"application/json; charset=UTF-8");
        if (!headers.containsKey((Object)"Authorization")) {
            if (AppContext.getInstance().get("Token") != null) {
                headers.add((Object)"Authorization", (Object)("Bearer " + ((TokenDto)AppContext.getInstance().get("Token")).getToken()));
            } else {
                headers.add((Object)"Authorization", (Object)"");
            }
        }
        this.builder.headers((MultivaluedMap)headers);
    }

    public Request(String target, Map<String, Object> queryParams) {
        this.webTarget = this.client.target(Parametros.resturl + target);
        queryParams.forEach((t, u) -> {
            if (u instanceof List) {
                for (String string : (List)u) {
                    this.webTarget = this.webTarget.queryParam(t, new Object[]{string});
                }
            } else {
                this.webTarget = this.webTarget.queryParam(t, new Object[]{u});
            }
        });
        this.webTarget = this.webTarget.queryParam("", new Object[]{""});
        this.builder = this.webTarget.request(new String[]{"application/json"});
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Content-Type", (Object)"application/json; charset=UTF-8");
        if (!headers.containsKey((Object)"Authorization")) {
            if (AppContext.getInstance().get("Token") != null) {
                headers.add((Object)"Authorization", (Object)("Bearer " + ((TokenDto)AppContext.getInstance().get("Token")).getToken()));
            } else {
                headers.add((Object)"Authorization", (Object)"");
            }
        }
        this.builder.headers((MultivaluedMap)headers);
    }

    public void setTarget(String target) {
        this.webTarget = this.client.target(this.urlBase + target);
        this.builder = this.webTarget.request(new String[]{"application/json"});
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.add((Object)"Content-Type", (Object)"application/json; charset=UTF-8");
        if (!headers.containsKey((Object)"Authorization")) {
            if (AppContext.getInstance().get("Token") != null) {
                headers.add((Object)"Authorization", (Object)("Bearer " + ((TokenDto)AppContext.getInstance().get("Token")).getToken()));
            } else {
                headers.add((Object)"Authorization", (Object)"");
            }
        }
        this.builder.headers((MultivaluedMap)headers);
    }

    public void setHeader(String nombre, Object valor) {
        this.builder.header(nombre, valor);
    }

    public void setHeader(MultivaluedMap<String, Object> valores) {
        valores.add((Object)"Content-Type", (Object)"application/json; charset=UTF-8");
        if (!valores.containsKey((Object)"Authorization")) {
            if (AppContext.getInstance().get("Token") != null) {
                valores.putSingle((Object)"Authorization", (Object)("Bearer " + ((TokenDto)AppContext.getInstance().get("Token")).getToken()));
            } else {
                valores.putSingle((Object)"Authorization", (Object)"");
            }
        }
        this.builder.headers(valores);
    }

    public void get() {
        this.response = this.builder.get();
    }

    public void getAsync() {
        this.responseFuture = this.builder.async().get();
    }

    public void post(Object clazz) {
        Entity entity = Entity.entity((Object)clazz, (String)"application/json; charset=UTF-8");
        this.response = this.builder.post(entity);
    }

    public void put(Object clazz) {
        Entity entity = Entity.entity((Object)clazz, (String)"application/json; charset=UTF-8");
        this.response = this.builder.put(entity);
    }

    public void delete() {
        this.response = this.builder.delete();
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public int getStatusAsync() throws InterruptedException, ExecutionException {
        return this.responseFuture.get().getStatus();
    }

    public Boolean isError() {
        return this.getStatus() != 200;
    }

    public Boolean isErrorAsync() throws InterruptedException, ExecutionException {
        return this.getStatusAsync() != 200;
    }

    public String getError() {
        if (this.response.getStatus() != 200) {
            if (this.response.getMediaType().equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
                return new String((String)this.response.readEntity(String.class));
            }
            String mensaje = this.response.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? (String)this.response.readEntity(String.class) : this.response.getStatusInfo().getReasonPhrase();
            return mensaje;
        }
        return null;
    }

    public Object readEntity(Class clazz) {
        return this.response.readEntity(clazz);
    }

    public Object readEntityAsync(Class clazz) throws InterruptedException, ExecutionException {
        return this.responseFuture.get().readEntity(clazz);
    }

    public Object readEntity(GenericType<?> genericType) {
        return this.response.readEntity(genericType);
    }
}

