@echo off
REM Script para abrir toda la documentación relacionada con el instalador

echo.
echo ╔══════════════════════════════════════════════════════════════════════╗
echo ║              DOCUMENTACIÓN PARA CREAR INSTALADOR                      ║
echo ║                 Factux Costa Rica - ElectricPos                       ║
echo ╚══════════════════════════════════════════════════════════════════════╝
echo.
echo Este script abrirá toda la documentación disponible.
echo.
echo Documentos disponibles:
echo   1. README.txt                    - Índice principal
echo   2. INSTRUCCIONES_RAPIDAS.txt     - Guía rápida
echo   3. GUIA_CREAR_INSTALADOR.md      - Guía completa
echo   4. RECURSOS.md                   - Enlaces útiles
echo.
echo Archivos de configuración:
echo   5. generator_updated.iss         - Config Inno Setup
echo   6. launch4jConfig_updated.xml    - Config Launch4j
echo.
set /p CHOICE="¿Qué deseas abrir? (1-6, o 0 para todo): "

if "%CHOICE%"=="0" goto OPEN_ALL
if "%CHOICE%"=="1" goto OPEN_README
if "%CHOICE%"=="2" goto OPEN_RAPIDAS
if "%CHOICE%"=="3" goto OPEN_GUIA
if "%CHOICE%"=="4" goto OPEN_RECURSOS
if "%CHOICE%"=="5" goto OPEN_ISS
if "%CHOICE%"=="6" goto OPEN_L4J

echo Opción inválida.
pause
exit /b 0

:OPEN_ALL
echo.
echo Abriendo toda la documentación...
start "" README.txt
timeout /t 1 >nul
start "" INSTRUCCIONES_RAPIDAS.txt
timeout /t 1 >nul
start "" ..\..\..\GUIA_CREAR_INSTALADOR.md
timeout /t 1 >nul
start "" RECURSOS.md
timeout /t 1 >nul
start "" generator_updated.iss
timeout /t 1 >nul
start "" launch4jConfig_updated.xml
goto END

:OPEN_README
start "" README.txt
goto END

:OPEN_RAPIDAS
start "" INSTRUCCIONES_RAPIDAS.txt
goto END

:OPEN_GUIA
start "" ..\..\..\GUIA_CREAR_INSTALADOR.md
goto END

:OPEN_RECURSOS
start "" RECURSOS.md
goto END

:OPEN_ISS
start "" generator_updated.iss
goto END

:OPEN_L4J
start "" launch4jConfig_updated.xml
goto END

:END
echo.
echo Documentos abiertos correctamente.
echo.
pause


