@echo off
REM ====================================================================
REM Launcher para Factux Costa Rica - ElectricPos
REM Usa JRE embebido para garantizar compatibilidad
REM ====================================================================

setlocal

REM Cambiar al directorio donde está el script
cd /d "%~dp0"

REM Configuración
set APP_NAME=Factux Costa Rica
set JAR_FILE=ElectricPos.jar
set JRE_PATH=jre\bin
set JAVA_EXE=%JRE_PATH%\javaw.exe
set JAVA_CONSOLE_EXE=%JRE_PATH%\java.exe

REM Verificar que existe el JAR
if not exist "%JAR_FILE%" (
    echo ERROR: No se encuentra %JAR_FILE%
    echo Verifica la instalación de %APP_NAME%
    pause
    exit /b 1
)

REM Verificar que existe el JRE embebido
if not exist "%JAVA_EXE%" (
    echo ERROR: No se encuentra Java en: %JAVA_EXE%
    echo.
    echo La instalación de %APP_NAME% está incompleta.
    echo Por favor, reinstala la aplicación.
    pause
    exit /b 1
)

REM Opciones de JVM (puedes ajustarlas según necesites)
set JAVA_OPTS=-Xms256m -Xmx1024m
set JAVA_OPTS=%JAVA_OPTS% -Dfile.encoding=UTF-8
set JAVA_OPTS=%JAVA_OPTS% -Duser.language=es
set JAVA_OPTS=%JAVA_OPTS% -Duser.country=CR

REM Ejecutar la aplicación sin consola (modo silencioso)
start "" "%JAVA_EXE%" %JAVA_OPTS% -jar "%JAR_FILE%"

REM Si quieres ver la consola para depuración, comenta la línea anterior
REM y descomenta la siguiente:
REM "%JAVA_CONSOLE_EXE%" %JAVA_OPTS% -jar "%JAR_FILE%"
REM pause

endlocal
exit /b 0


