@echo off
REM ====================================================================
REM Script para preparar la carpeta de release para el instalador
REM Factux Costa Rica - ElectricPos
REM ====================================================================

setlocal enabledelayedexpansion

echo ============================================
echo   Preparar Release de Factux
echo ============================================
echo.

REM Configuración
set PROJECT_DIR=%~dp0..\..\..
set DIST_DIR=%PROJECT_DIR%\dist
set RELEASE_DIR=C:\factux_release
set VERSION=4.4

echo [1/6] Verificando que el proyecto esté compilado...
if not exist "%DIST_DIR%\ElectricPos.jar" (
    echo ERROR: No se encuentra ElectricPos.jar
    echo Por favor, compila el proyecto primero con NetBeans (Clean and Build - F11)
    pause
    exit /b 1
)
echo OK - JAR encontrado

echo.
echo [2/6] Creando carpeta de release...
if exist "%RELEASE_DIR%" (
    echo La carpeta %RELEASE_DIR% ya existe
    set /p OVERWRITE="¿Deseas sobrescribirla? (S/N): "
    if /i "!OVERWRITE!"=="S" (
        rmdir /s /q "%RELEASE_DIR%"
        mkdir "%RELEASE_DIR%"
    ) else (
        echo Cancelado por el usuario
        pause
        exit /b 0
    )
) else (
    mkdir "%RELEASE_DIR%"
)
echo OK - Carpeta creada

echo.
echo [3/6] Copiando archivos del proyecto...

REM Copiar JAR principal
copy "%DIST_DIR%\ElectricPos.jar" "%RELEASE_DIR%\" >nul
echo   - ElectricPos.jar copiado

REM Copiar librerías
if exist "%DIST_DIR%\lib\" (
    xcopy /E /I /Y "%DIST_DIR%\lib" "%RELEASE_DIR%\lib" >nul
    echo   - Librerías copiadas
) else (
    echo   ADVERTENCIA: No se encontró la carpeta lib
)

REM Copiar launcher
copy "%~dp0\FactuxLauncher.bat" "%RELEASE_DIR%\" >nul
echo   - FactuxLauncher.bat copiado

REM Copiar ejecutable si existe
if exist "%~dp0\FactuxLauncher.exe" (
    copy "%~dp0\FactuxLauncher.exe" "%RELEASE_DIR%\" >nul
    echo   - FactuxLauncher.exe copiado
) else (
    echo   NOTA: FactuxLauncher.exe no encontrado (se puede crear después con Launch4j)
)

REM Copiar icono si existe
if exist "%PROJECT_DIR%\resources\icono.ico" (
    copy "%PROJECT_DIR%\resources\icono.ico" "%RELEASE_DIR%\" >nul
    echo   - icono.ico copiado
) else (
    if exist "%~dp0\icono.ico" (
        copy "%~dp0\icono.ico" "%RELEASE_DIR%\" >nul
        echo   - icono.ico copiado
    ) else (
        echo   ADVERTENCIA: No se encontró icono.ico
    )
)

echo OK - Archivos copiados

echo.
echo [4/6] Verificando Java JRE...
if exist "%RELEASE_DIR%\jre\" (
    echo OK - JRE encontrado en la carpeta de release
) else (
    echo.
    echo ============================================
    echo   ACCIÓN REQUERIDA: Descargar JRE 8
    echo ============================================
    echo.
    echo No se encontró la carpeta JRE embebido.
    echo.
    echo Para incluir Java 8 en tu instalador necesitas:
    echo.
    echo 1. Descargar JRE 8 desde:
    echo    - Adoptium (Recomendado): https://adoptium.net/temurin/releases/?version=8
    echo    - Oracle: https://www.oracle.com/java/technologies/javase/javase8-archive-downloads.html
    echo.
    echo 2. Si descargaste un ZIP:
    echo    - Extrae el contenido
    echo    - Copia la carpeta JRE completa a: %RELEASE_DIR%\jre
    echo.
    echo 3. Si descargaste un instalador:
    echo    - Instala Java 8
    echo    - Copia la carpeta de: C:\Program Files\Java\jre1.8.0_XXX
    echo    - Pégala como: %RELEASE_DIR%\jre
    echo.
    echo La carpeta final debe ser: %RELEASE_DIR%\jre\bin\java.exe
    echo.
)

echo.
echo [5/6] Creando carpeta para el instalador...
if not exist "%RELEASE_DIR%\installer" (
    mkdir "%RELEASE_DIR%\installer"
)
echo OK - Carpeta de instalador lista

echo.
echo [6/6] Copiando script de Inno Setup...
copy "%~dp0\generator_updated.iss" "%RELEASE_DIR%\generator.iss" >nul
echo OK - Script de Inno Setup copiado

echo.
echo ============================================
echo   PREPARACIÓN COMPLETADA
echo ============================================
echo.
echo Carpeta de release: %RELEASE_DIR%
echo.
echo PRÓXIMOS PASOS:
echo.

if not exist "%RELEASE_DIR%\jre\" (
    echo [PENDIENTE] 1. Descargar y copiar JRE 8 a: %RELEASE_DIR%\jre
) else (
    echo [OK] 1. JRE 8 ya está en su lugar
)

if not exist "%RELEASE_DIR%\FactuxLauncher.exe" (
    echo [OPCIONAL] 2. Crear FactuxLauncher.exe con Launch4j
    echo              (Puedes usar solo el .bat si prefieres)
) else (
    echo [OK] 2. FactuxLauncher.exe ya existe
)

echo.
echo [ÚLTIMO PASO] 3. Abrir Inno Setup y compilar:
echo                   %RELEASE_DIR%\generator.iss
echo.
echo El instalador se generará en:
echo   %RELEASE_DIR%\installer\FactuxSetup_v%VERSION%.exe
echo.
echo ============================================

REM Abrir la carpeta de release
echo.
set /p OPEN="¿Abrir la carpeta de release ahora? (S/N): "
if /i "%OPEN%"=="S" (
    explorer "%RELEASE_DIR%"
)

echo.
echo Consulta GUIA_CREAR_INSTALADOR.md para más detalles.
echo.
pause
endlocal


