# Recursos y Links Útiles para Crear Instaladores

## 🔧 Herramientas Principales

### Launch4j
**Qué es:** Herramienta para convertir archivos JAR en ejecutables .exe nativos de Windows

- **Sitio oficial:** https://launch4j.sourceforge.net/
- **Documentación:** https://launch4j.sourceforge.net/docs.html
- **Descargar:** https://sourceforge.net/projects/launch4j/files/
- **Versión recomendada:** 3.14 o superior
- **Licencia:** BSD/MIT (gratis y open source)

**Alternativas:**
- JSmooth: http://jsmooth.sourceforge.net/ (más antiguo)
- Packr: https://github.com/libgdx/packr
- JWrapper: https://www.jwrapper.com/ (comercial)

---

### Inno Setup
**Qué es:** Creador de instaladores profesionales para Windows

- **Sitio oficial:** https://jrsoftware.org/isinfo.php
- **Descargar:** https://jrsoftware.org/isdl.php
- **Documentación:** https://jrsoftware.org/ishelp/
- **Tutorial:** https://jrsoftware.org/ishelp/topic_tutorial.htm
- **Licencia:** Gratuito (incluso para uso comercial)

**Alternativas:**
- NSIS: https://nsis.sourceforge.io/ (más técnico)
- Advanced Installer: https://www.advancedinstaller.com/ (comercial con versión free)
- WiX Toolset: https://wixtoolset.org/ (más complejo, basado en XML)
- Install4j: https://www.ej-technologies.com/products/install4j/overview.html (comercial)

---

## ☕ Java Runtime Environment

### Adoptium (Eclipse Temurin) - RECOMENDADO
**Por qué:** Gratis, open source, sin restricciones de licencia

- **Sitio oficial:** https://adoptium.net/
- **Descargas JRE 8:** https://adoptium.net/temurin/releases/?version=8
- **Documentación:** https://adoptium.net/docs/
- **Licencia:** GPLv2 with Classpath Exception (completamente gratis)

### Oracle JRE 8
**Advertencia:** Restricciones de licencia para distribución comercial

- **Sitio oficial:** https://www.oracle.com/java/technologies/javase-downloads.html
- **Archivo Java 8:** https://www.oracle.com/java/technologies/javase/javase8-archive-downloads.html
- **Licencia:** Verificar Oracle Binary Code License Agreement
- **Nota:** Requiere cuenta de Oracle para descargar

### Otras Opciones de JRE Gratuitas

**Amazon Corretto:**
- https://aws.amazon.com/corretto/
- JRE 8: https://docs.aws.amazon.com/corretto/latest/corretto-8-ug/downloads-list.html

**Azul Zulu:**
- https://www.azul.com/downloads/
- Versión Community gratis

**Microsoft OpenJDK:**
- https://www.microsoft.com/openjdk
- Solo disponible JDK 11+ (no sirve para Java 8)

---

## 📚 Documentación y Tutoriales

### JavaFX Packaging
- **Empaquetado oficial:** https://openjfx.io/openjfx-docs/#install-javafx
- **jpackage (Java 14+):** https://docs.oracle.com/en/java/javase/14/docs/specs/man/jpackage.html
- **JavaFX Maven Plugin:** https://github.com/openjfx/javafx-maven-plugin

### Tutoriales de Empaquetado

**Launch4j + Inno Setup:**
- Tutorial completo: https://www.youtube.com/watch?v=example (buscar en YouTube)
- Guía paso a paso: https://github.com/examples (buscar en GitHub)

**jlink (para Java 9+):**
- https://docs.oracle.com/javase/9/tools/jlink.htm
- https://medium.com/@adam_carroll/java-packager-with-jdk11-31b3d620f4a8

---

## 🛠️ Herramientas Complementarias

### Iconos
**Para crear archivos .ico:**
- **Online:** https://convertio.co/es/png-ico/
- **Online:** https://www.icoconverter.com/
- **Software:** IcoFX - https://icofx.ro/

**Bancos de iconos gratuitos:**
- https://www.flaticon.com/
- https://icons8.com/
- https://fontawesome.com/

### Compresión de EXE
**UPX (Ultimate Packer for eXecutables):**
- https://upx.github.io/
- Reduce el tamaño de los ejecutables
- Funciona con el .exe generado por Launch4j

### Firmar Digitalmente tu Aplicación
**SignTool (Windows SDK):**
- https://docs.microsoft.com/en-us/windows/win32/seccrypto/signtool
- Requiere certificado de firma de código

**Proveedores de certificados:**
- Sectigo: https://sectigo.com/
- DigiCert: https://www.digicert.com/
- GlobalSign: https://www.globalsign.com/

---

## 📖 Guías Específicas por Escenario

### Si usas Maven
```xml
<!-- Plugin para crear ejecutable con dependencies -->
<plugin>
    <groupId>org.apache.maven.plugins</groupId>
    <artifactId>maven-assembly-plugin</artifactId>
    <version>3.3.0</version>
    <configuration>
        <archive>
            <manifest>
                <mainClass>electricpos.Main</mainClass>
            </manifest>
        </archive>
        <descriptorRefs>
            <descriptorRef>jar-with-dependencies</descriptorRef>
        </descriptorRefs>
    </configuration>
</plugin>
```

### Si usas Gradle
```gradle
// Plugin para crear fat JAR
plugins {
    id 'com.github.johnrengelman.shadow' version '7.1.2'
}

shadowJar {
    manifest {
        attributes 'Main-Class': 'electricpos.Main'
    }
}
```

---

## 🔍 Comparación de Métodos

| Método | Java 8 | Dificultad | JRE Embebido | Multiplataforma |
|--------|--------|------------|--------------|-----------------|
| Launch4j + Inno | ✅ | Fácil | ✅ | ❌ (solo Windows) |
| jpackage | ❌ (Java 14+) | Media | ✅ | ✅ |
| jlink | ❌ (Java 9+) | Alta | ✅ | ✅ |
| Install4j | ✅ | Fácil | ✅ | ✅ (comercial) |
| Ejecutable JAR | ✅ | Muy fácil | ❌ | ✅ |

---

## 🎓 Recursos de Aprendizaje

### Videos Tutoriales (YouTube)
Busca:
- "JavaFX packaging windows installer"
- "Launch4j tutorial español"
- "Inno Setup tutorial"
- "Java executable with embedded JRE"

### Comunidades y Foros
- **Stack Overflow:** https://stackoverflow.com/questions/tagged/javafx+packaging
- **Reddit JavaFX:** https://www.reddit.com/r/JavaFX/
- **Oracle Community:** https://community.oracle.com/tech/developers/categories/java

### Repositorios de Ejemplo
- https://github.com/edvin/tornadofx-samples
- https://github.com/openjfx/samples
- https://github.com/FXyz/FXyzSamples

---

## 💡 Tips y Mejores Prácticas

### Reducir Tamaño del Instalador
1. Usa JRE en lugar de JDK (ahorra ~50 MB)
2. Elimina módulos de Java no usados con jlink (Java 9+)
3. Comprime el ejecutable con UPX
4. Usa compresión LZMA2/Ultra64 en Inno Setup
5. Considera crear versión de 32-bit (más pequeña)

### Mejorar Experiencia del Usuario
1. Incluye splash screen en Launch4j
2. Agrega icono personalizado (.ico)
3. Configura asociaciones de archivos en Inno Setup
4. Implementa actualizaciones automáticas
5. Firma digitalmente la aplicación

### Solución de Problemas Comunes

**"Could not find or load main class"**
- Verifica el MANIFEST.MF del JAR
- Asegúrate que todas las dependencias están en lib/

**"Class not found"**
- Incluye todas las librerías en el instalador
- Verifica el classpath en el .bat

**"javafx.* no se encuentra"**
- JavaFX no está incluido en Java 8 standalone
- Asegúrate de incluir las librerías JavaFX

---

## 📞 Soporte Adicional

### Errores de Java
- **JavaFX:** https://openjfx.io/
- **Oracle Support:** https://www.oracle.com/java/technologies/java-se-support-roadmap.html

### Errores de Instalador
- **Inno Setup Forum:** https://groups.google.com/g/innosetup
- **Launch4j Issues:** https://sourceforge.net/p/launch4j/bugs/

---

## 📝 Checklist para Distribución

- [ ] Aplicación compilada sin errores
- [ ] Todas las dependencias incluidas
- [ ] JRE 8 descargado y preparado
- [ ] Icono en formato .ico
- [ ] Launch4j configurado (opcional)
- [ ] Inno Setup configurado
- [ ] Instalador generado y probado
- [ ] Instalador probado en PC limpia (sin Java)
- [ ] Accesos directos funcionan correctamente
- [ ] Desinstalador funciona correctamente
- [ ] Documentación de usuario incluida
- [ ] Certificado de firma (opcional pero recomendado)

---

## 🔄 Actualización Continua

**Para futuras versiones:**
1. Incrementa el número de versión en todos los archivos
2. Actualiza el changelog
3. Genera nuevo instalador
4. Prueba en diferentes versiones de Windows
5. Distribuye a través de tu canal preferido

**Migración a Java 11+ (futuro):**
- Considera usar jpackage (disponible desde Java 14)
- Más fácil de mantener y más moderno
- Soporta múltiples plataformas nativamente

---

**Última actualización:** Octubre 2025
**Autor:** Space Software Costa Rica
**Proyecto:** Factux Costa Rica - ElectricPos


