; Script de Inno Setup para Factux Costa Rica
; Actualizado para incluir JRE 8 embebido

#define MyAppName "Factux Costa Rica"
#define MyAppVersion "4.4"
#define MyAppPublisher "Space Software Costa Rica"
#define MyAppURL "https://www.factuxcr.com/"
#define MyAppExeName "FactuxLauncher.exe"
; *** IMPORTANTE: Cambia esta ruta a donde preparaste los archivos ***
#define SourcePath "C:\factux_release"

[Setup]
; Información de la aplicación
AppId={{FACTUX-CR-ELECTRIC-POS-APP}}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}

; Directorio de instalación
DefaultDirName={localappdata}\{#MyAppName}
DefaultGroupName={#MyAppName}
DisableProgramGroupPage=yes

; Archivos de salida
OutputDir={#SourcePath}\installer
OutputBaseFilename=FactuxSetup_v{#MyAppVersion}

; Compresión
Compression=lzma2/ultra64
SolidCompression=yes
LZMAUseSeparateProcess=yes
LZMADictionarySize=1048576
LZMANumFastBytes=273

; Icono y apariencia
SetupIconFile={#SourcePath}\icono.ico
WizardStyle=modern

; Arquitectura
ArchitecturesInstallIn64BitMode=x64

; Privilegios (no requiere admin)
PrivilegesRequired=lowest

; Información de versión
VersionInfoVersion={#MyAppVersion}
VersionInfoCompany={#MyAppPublisher}
VersionInfoDescription=Instalador de {#MyAppName}

; Sin crear desinstalador en panel de control (opcional, quita si quieres que aparezca)
; CreateUninstallRegKey=yes

[Languages]
Name: "spanish"; MessagesFile: "compiler:Languages\Spanish.isl"

[Tasks]
Name: "desktopicon"; Description: "Crear acceso directo en el escritorio"; GroupDescription: "Opciones adicionales:"
Name: "quicklaunchicon"; Description: "Crear acceso directo en la barra de inicio rápido"; GroupDescription: "Opciones adicionales:"; Flags: unchecked

[Files]
; Archivos principales
Source: "{#SourcePath}\ElectricPos.jar"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#SourcePath}\FactuxLauncher.bat"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#SourcePath}\FactuxLauncher.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#SourcePath}\icono.ico"; DestDir: "{app}"; Flags: ignoreversion

; Librerías
Source: "{#SourcePath}\lib\*"; DestDir: "{app}\lib"; Flags: ignoreversion recursesubdirs createallsubdirs

; Java Runtime Environment 8 embebido
Source: "{#SourcePath}\jre\*"; DestDir: "{app}\jre"; Flags: ignoreversion recursesubdirs createallsubdirs

; Archivos adicionales (descomenta si los tienes)
; Source: "{#SourcePath}\resources\*"; DestDir: "{app}\resources"; Flags: ignoreversion recursesubdirs createallsubdirs
; Source: "{#SourcePath}\manual.pdf"; DestDir: "{app}"; Flags: ignoreversion isreadme

[Icons]
; Icono en el menú inicio
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; WorkingDir: "{app}"; IconFilename: "{app}\icono.ico"
Name: "{group}\Desinstalar {#MyAppName}"; Filename: "{uninstallexe}"

; Icono en el escritorio
Name: "{commondesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon; WorkingDir: "{app}"; IconFilename: "{app}\icono.ico"

; Icono en inicio rápido
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: quicklaunchicon; WorkingDir: "{app}"; IconFilename: "{app}\icono.ico"

[Run]
; Ejecutar la aplicación después de instalar
Filename: "{app}\{#MyAppExeName}"; Description: "Ejecutar {#MyAppName} ahora"; Flags: nowait postinstall skipifsilent

[UninstallDelete]
; Limpiar archivos generados por la aplicación (ajusta según necesites)
Type: filesandordirs; Name: "{app}\logs"
Type: filesandordirs; Name: "{app}\temp"
Type: files; Name: "{app}\*.log"

[Code]
// Código Pascal para verificaciones adicionales

function InitializeSetup(): Boolean;
var
  ResultCode: Integer;
begin
  Result := True;
  
  // Aquí puedes agregar verificaciones personalizadas
  // Por ejemplo, verificar si hay otra instancia instalada
end;

procedure CurStepChanged(CurStep: TSetupStep);
begin
  if CurStep = ssPostInstall then
  begin
    // Acciones después de la instalación
    // Por ejemplo, configurar archivos de configuración
  end;
end;

function InitializeUninstall(): Boolean;
var
  ResultCode: Integer;
begin
  Result := True;
  
  // Preguntar confirmación antes de desinstalar
  if MsgBox('¿Estás seguro que deseas desinstalar ' + '{#MyAppName}' + '?', mbConfirmation, MB_YESNO) = IDNO then
    Result := False;
end;


