/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXDialog$$Lambda$1;
import com.jfoenix.controls.JFXDialog$$Lambda$2;
import com.jfoenix.controls.JFXDialog$$Lambda$3;
import com.jfoenix.controls.JFXDialog$$Lambda$4;
import com.jfoenix.controls.JFXDialog$$Lambda$5;
import com.jfoenix.controls.JFXDialog$$Lambda$6;
import com.jfoenix.controls.JFXDialog$$Lambda$7;
import com.jfoenix.controls.events.JFXDialogEvent;
import com.jfoenix.converters.DialogTransitionConverter;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.CachedTransition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

@DefaultProperty(value="content")
public class JFXDialog
extends StackPane {
    private StackPane contentHolder;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private StackPane dialogContainer;
    private Region content;
    private Transition animation;
    EventHandler<? super MouseEvent> closeHandler;
    private BooleanProperty overlayClose;
    private static final String DEFAULT_STYLE_CLASS = "jfx-dialog";
    private StyleableObjectProperty<DialogTransition> transitionType;
    private List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private final ObjectProperty<EventHandler<? super JFXDialogEvent>> onDialogClosedProperty;
    private ObjectProperty<EventHandler<? super JFXDialogEvent>> onDialogOpenedProperty;

    public JFXDialog() {
        this(null, null, DialogTransition.CENTER);
    }

    public JFXDialog(StackPane dialogContainer, Region content, DialogTransition transitionType) {
        this.closeHandler = JFXDialog$$Lambda$1.lambdaFactory$(this);
        this.overlayClose = new SimpleBooleanProperty(true);
        this.transitionType = new SimpleStyleableObjectProperty(StyleableProperties.DIALOG_TRANSITION, (Object)this, "dialogTransition", (Object)DialogTransition.CENTER);
        this.onDialogClosedProperty = new ObjectPropertyBase<EventHandler<? super JFXDialogEvent>>(){

            protected void invalidated() {
                JFXDialog.this.setEventHandler(JFXDialogEvent.CLOSED, (EventHandler)this.get());
            }

            public Object getBean() {
                return JFXDialog.this;
            }

            public String getName() {
                return "onClosed";
            }
        };
        this.onDialogOpenedProperty = new ObjectPropertyBase<EventHandler<? super JFXDialogEvent>>(){

            protected void invalidated() {
                JFXDialog.this.setEventHandler(JFXDialogEvent.OPENED, (EventHandler)this.get());
            }

            public Object getBean() {
                return JFXDialog.this;
            }

            public String getName() {
                return "onOpened";
            }
        };
        this.initialize();
        this.setContent(content);
        this.setDialogContainer(dialogContainer);
        this.transitionType.set((Object)transitionType);
        this.initChangeListeners();
    }

    public JFXDialog(StackPane dialogContainer, Region content, DialogTransition transitionType, boolean overlayClose) {
        this.closeHandler = JFXDialog$$Lambda$2.lambdaFactory$(this);
        this.overlayClose = new SimpleBooleanProperty(true);
        this.transitionType = new SimpleStyleableObjectProperty(StyleableProperties.DIALOG_TRANSITION, (Object)this, "dialogTransition", (Object)DialogTransition.CENTER);
        this.onDialogClosedProperty = new /* invalid duplicate definition of identical inner class */;
        this.onDialogOpenedProperty = new /* invalid duplicate definition of identical inner class */;
        this.setOverlayClose(overlayClose);
        this.initialize();
        this.setContent(content);
        this.setDialogContainer(dialogContainer);
        this.transitionType.set((Object)transitionType);
        this.initChangeListeners();
    }

    private void initChangeListeners() {
        this.overlayCloseProperty().addListener(JFXDialog$$Lambda$3.lambdaFactory$(this));
    }

    private void initialize() {
        this.setVisible(false);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.transitionType.addListener(JFXDialog$$Lambda$4.lambdaFactory$(this));
        this.contentHolder = new StackPane();
        this.contentHolder.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, new CornerRadii(2.0), null)}));
        JFXDepthManager.setDepth((Node)this.contentHolder, 4);
        this.contentHolder.setPickOnBounds(false);
        this.contentHolder.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.getChildren().add((Object)this.contentHolder);
        this.getStyleClass().add((Object)"jfx-dialog-overlay-pane");
        StackPane.setAlignment((Node)this.contentHolder, (Pos)Pos.CENTER);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)0, (int)0, (int)0, (double)0.1), null, null)}));
        if (this.overlayClose.get()) {
            this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.closeHandler);
        }
        this.contentHolder.addEventHandler(MouseEvent.ANY, JFXDialog$$Lambda$5.lambdaFactory$());
    }

    public StackPane getDialogContainer() {
        return this.dialogContainer;
    }

    public void setDialogContainer(StackPane dialogContainer) {
        if (dialogContainer != null) {
            this.dialogContainer = dialogContainer;
            if (this.dialogContainer.getChildren().indexOf((Object)this) == -1 || this.dialogContainer.getChildren().indexOf((Object)this) != this.dialogContainer.getChildren().size() - 1) {
                this.dialogContainer.getChildren().remove((Object)this);
                this.dialogContainer.getChildren().add((Object)this);
            }
            this.offsetX = this.getParent().getBoundsInLocal().getWidth();
            this.offsetY = this.getParent().getBoundsInLocal().getHeight();
            this.animation = this.getShowAnimation((DialogTransition)((Object)this.transitionType.get()));
        }
    }

    public Region getContent() {
        return this.content;
    }

    public void setContent(Region content) {
        if (content != null) {
            this.content = content;
            this.content.setPickOnBounds(false);
            this.contentHolder.getChildren().setAll((Object[])new Node[]{content});
        }
    }

    public final BooleanProperty overlayCloseProperty() {
        return this.overlayClose;
    }

    public final boolean isOverlayClose() {
        return this.overlayCloseProperty().get();
    }

    public final void setOverlayClose(boolean overlayClose) {
        this.overlayCloseProperty().set(overlayClose);
    }

    public void show(StackPane dialogContainer) {
        this.setDialogContainer(dialogContainer);
        this.animation.play();
    }

    public void show() {
        if (this.dialogContainer == null) {
            System.err.println("ERROR: JFXDialog container is not set!");
            return;
        }
        this.setDialogContainer(this.dialogContainer);
        this.animation.play();
    }

    public void close() {
        this.animation.setRate(-1.0);
        this.animation.play();
        this.animation.setOnFinished(JFXDialog$$Lambda$6.lambdaFactory$(this));
    }

    private Transition getShowAnimation(DialogTransition transitionType) {
        CachedTransition animation = null;
        if (this.contentHolder != null) {
            switch (transitionType) {
                case LEFT: {
                    this.contentHolder.setScaleX(1.0);
                    this.contentHolder.setScaleY(1.0);
                    this.contentHolder.setTranslateX(-this.offsetX);
                    animation = new LeftTransition();
                    break;
                }
                case RIGHT: {
                    this.contentHolder.setScaleX(1.0);
                    this.contentHolder.setScaleY(1.0);
                    this.contentHolder.setTranslateX(this.offsetX);
                    animation = new RightTransition();
                    break;
                }
                case TOP: {
                    this.contentHolder.setScaleX(1.0);
                    this.contentHolder.setScaleY(1.0);
                    this.contentHolder.setTranslateY(-this.offsetY);
                    animation = new TopTransition();
                    break;
                }
                case BOTTOM: {
                    this.contentHolder.setScaleX(1.0);
                    this.contentHolder.setScaleY(1.0);
                    this.contentHolder.setTranslateY(this.offsetY);
                    animation = new BottomTransition();
                    break;
                }
                default: {
                    this.contentHolder.setScaleX(0.0);
                    this.contentHolder.setScaleY(0.0);
                    animation = new CenterTransition();
                }
            }
        }
        if (animation != null) {
            animation.setOnFinished(JFXDialog$$Lambda$7.lambdaFactory$(this));
        }
        return animation;
    }

    private void resetProperties() {
        this.setVisible(false);
        this.contentHolder.setTranslateX(0.0);
        this.contentHolder.setTranslateY(0.0);
        this.contentHolder.setScaleX(1.0);
        this.contentHolder.setScaleY(1.0);
    }

    public DialogTransition getTransitionType() {
        return this.transitionType == null ? DialogTransition.CENTER : (DialogTransition)((Object)this.transitionType.get());
    }

    public StyleableObjectProperty<DialogTransition> transitionTypeProperty() {
        return this.transitionType;
    }

    public void setTransitionType(DialogTransition transition) {
        this.transitionType.set((Object)transition);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        if (this.STYLEABLES == null) {
            ArrayList styleables = new ArrayList(Parent.getClassCssMetaData());
            styleables.addAll(JFXDialog.getClassCssMetaData());
            styleables.addAll(StackPane.getClassCssMetaData());
            this.STYLEABLES = Collections.unmodifiableList(styleables);
        }
        return this.STYLEABLES;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    public ObjectProperty<EventHandler<? super JFXDialogEvent>> onDialogClosedProperty() {
        return this.onDialogClosedProperty;
    }

    public void setOnDialogClosed(EventHandler<? super JFXDialogEvent> handler) {
        this.onDialogClosedProperty().set(handler);
    }

    public EventHandler<? super JFXDialogEvent> getOnDialogClosed() {
        return (EventHandler)this.onDialogClosedProperty().get();
    }

    public ObjectProperty<EventHandler<? super JFXDialogEvent>> onDialogOpenedProperty() {
        return this.onDialogOpenedProperty;
    }

    public void setOnDialogOpened(EventHandler<? super JFXDialogEvent> handler) {
        this.onDialogOpenedProperty().set(handler);
    }

    public EventHandler<? super JFXDialogEvent> getOnDialogOpened() {
        return (EventHandler)this.onDialogOpenedProperty().get();
    }

    static /* synthetic */ void lambda$getShowAnimation$5(JFXDialog this_, ActionEvent finish) {
        Event.fireEvent((EventTarget)this_, (Event)new JFXDialogEvent(JFXDialogEvent.OPENED));
    }

    static /* synthetic */ void lambda$close$4(JFXDialog this_, ActionEvent e) {
        this_.resetProperties();
        Event.fireEvent((EventTarget)this_, (Event)new JFXDialogEvent(JFXDialogEvent.CLOSED));
        this_.dialogContainer.getChildren().remove((Object)this_);
    }

    static /* synthetic */ void lambda$initialize$3(MouseEvent e) {
        e.consume();
    }

    static /* synthetic */ void lambda$initialize$2(JFXDialog this_, ObservableValue o, DialogTransition oldVal, DialogTransition newVal) {
        this_.animation = this_.getShowAnimation((DialogTransition)((Object)this_.transitionType.get()));
    }

    static /* synthetic */ void lambda$initChangeListeners$1(JFXDialog this_, ObservableValue o, Boolean oldVal, Boolean newVal) {
        if (newVal.booleanValue()) {
            this_.addEventHandler(MouseEvent.MOUSE_PRESSED, this_.closeHandler);
        } else {
            this_.removeEventHandler(MouseEvent.MOUSE_PRESSED, this_.closeHandler);
        }
    }

    static /* synthetic */ void lambda$new$0(JFXDialog this_, MouseEvent e) {
        this_.close();
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXDialog, DialogTransition> DIALOG_TRANSITION = new CssMetaData<JFXDialog, DialogTransition>("-jfx-dialog-transition", DialogTransitionConverter.getInstance(), DialogTransition.CENTER){

            public boolean isSettable(JFXDialog control) {
                return control.transitionType == null || !control.transitionType.isBound();
            }

            public StyleableProperty<DialogTransition> getStyleableProperty(JFXDialog control) {
                return control.transitionTypeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Parent.getClassCssMetaData());
            Collections.addAll(styleables, DIALOG_TRANSITION);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    private class CenterTransition
    extends CachedTransition {
        CenterTransition() {
            super((Node)JFXDialog.this.contentHolder, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.contentHolder.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.contentHolder.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    private class BottomTransition
    extends CachedTransition {
        BottomTransition() {
            super((Node)JFXDialog.this.contentHolder, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateYProperty(), (Object)JFXDialog.this.offsetY, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    private class TopTransition
    extends CachedTransition {
        TopTransition() {
            super((Node)JFXDialog.this.contentHolder, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateYProperty(), (Object)(-JFXDialog.this.offsetY), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    private class RightTransition
    extends CachedTransition {
        RightTransition() {
            super((Node)JFXDialog.this.contentHolder, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateXProperty(), (Object)JFXDialog.this.offsetX, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    private class LeftTransition
    extends CachedTransition {
        LeftTransition() {
            super((Node)JFXDialog.this.contentHolder, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateXProperty(), (Object)(-JFXDialog.this.offsetX), Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)false, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)10.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.visibleProperty(), (Object)true, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)JFXDialog.this.contentHolder.translateXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)JFXDialog.this.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.4));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }

    public static enum DialogTransition {
        CENTER,
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }
}

